#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import time
import os.path
import ConfigParser
import sys
import commands
import configwriter
import shutil

import recdblist
def install():
    recdblist.printutf8(u"rec10の環境インストールを開始します。")
    time.sleep(1)
    recdblist.printutf8(u"環境インストール処理中・・・")
    path = str(os.path.dirname(os.path.abspath(__file__)))
    confp = ConfigParser.SafeConfigParser()
    Conf = 'rec10.conf'
    confpath=""
    if os.path.exists(os.path.join(path,Conf)):
        confpath=os.path.join(path,Conf)
    elif os.path.exists(os.path.join("/etc","rec10.conf")):
        confpath=os.path.join("/etc","rec10.conf")
    elif os.path.exists(os.path.join("/etc/rec10","rec10.conf")):
        confpath=os.path.join("/etc/rec10","rec10.conf")
    if confpath!="":
        confp.read(confpath)
    else:
        recdblist.printutf8(u"rec10.confが見つかりません。")
        recdblist.printutf8(u"このinstall.pyと同じフォルダに置くか、/etc/rec10.confもしくは/etc/rec10/rec10.confにおいてください。")
        sys.exit(1)
    recdblist.printutf8(u"設定ファイルの読み込みを確認//設定ファイルのパスは"+confpath)
    if confp.get('path',"recpath")=="/path of /recording":
        recdblist.printutf8(u"録画先のフォルダを設定してください(recpath=)")
        sys.exit(1)
    recdblist.printutf8(u"DB処理に入ります")
    if os.path.exists(os.path.join(path,"rec10d.py")):
        try:
            import rec10d
            rec10d.rec10db.drop_in_status()
            rec10d.rec10db.drop_in_settings()
            time.sleep(2)
            rec10d.rec10db.new_in_status()
            rec10d.rec10db.new_in_settings()
        except Exception, inst:
            recdblist.printutf8(u"DB処理中にエラーが出ました。configファイルのDB設定を見直してください。")
            print type(inst)
            print inst
    recdblist.printutf8(u"チャンネル設定に入ります")
    if os.path.exists(os.path.join(path,"chlist.xml")):
        recdblist.printutf8(u"チャンネルリストが見つかりました。||chlist.xml")
    else:
        recdblist.printutf8(u"チャンネルリストが見つかりません。"+os.path.join(path,"chlist.xml")+u"を作成してください。")
        recdblist.printutf8(u"東京/名古屋/神戸のサンプルがchlist_sample_*.xmlにあるため、参考にしてください。")
        sys.exit(1)
    bsok=int(confp.get('env',"bs"))
    csok=int(confp.get('env',"cs"))
    import chdata
    chdata.new_chdata(bsok,csok)
    recdblist.printutf8(u"おめでとうございます　初期設定は完了しました。")
    recdblist.printutf8(u"rec10を実行するユーザーのcrontabに"+os.path.join(path,"rec10")+u"を追加してください(5分周期が目安)")
    import rec10d
    rec10d.rec10db.change_installed_in_status()
def getpath(cmd):
    recdblist.printutf8(cmd+u"の場所を確認中")
    txt=commands.getoutput(u"which "+cmd)
    if len(txt.split(" "))>3:
        recdblist.printutf8(cmd+u"の場所を確認できませんでした。終了します")
        sys.exit(1)
    else:
        recdblist.printutf8(cmd+u" : "+txt)
        if len(txt.splitlines()):
            txt=txt.splitlines()[0]
        return txt.strip()
def move():
    path = str(os.path.dirname(os.path.abspath(__file__)))
    recdblist.printutf8(u"rec10 ver 0.9.1 installer.")
    recdblist.printutf8(u"rec10のインストールを開始します。")
    maxn=10
    configwriter.setpath(u"wine", getpath(u"wine"))
    configwriter.setpath(u"recpt1", getpath(u"recpt1"))
    #configwriter.setpath(u"xvfb-run", getpath(u"xvfb-run"))
    configwriter.setpath(u"mkvmerge", getpath(u"mkvmerge"))
    configwriter.setpath(u"b25", getpath(u"b25"))
    recdblist.printutf8(u"必須環境の設定が完了しました")
    recdblist.printutf8(u"個人設定に入ります")
    recdblist.printutf8(u"rec10の録画ファイルが置かれる場所を入力してください(1/"+str(maxn)+")")
    recdblist.printutf8(u"100GB程度は確保されている必要があります")
    recpath=raw_input("path : ")
    configwriter.setpath(u"recpath",recpath)
    recdblist.printutf8(u"DBの設定に入ります。")
    recdblist.printutf8(u"rec10が使用するMySQLのユーザーを設定してください。(2/"+str(maxn)+")")
    mysql_user=raw_input("mysql_user : ")
    configwriter.setdbpath("mysql_user", mysql_user)
    recdblist.printutf8(u"パスワードを設定してください(3/"+str(maxn)+")")
    mysql_passwd=raw_input("mysql_passwd : ")
    configwriter.setdbpath("mysql_passwd", mysql_passwd)
    recdblist.printutf8(u"同時録画可能数の設定に入ります")
    recdblist.printutf8(u"TE(地デジ)録画可能数(PT*だと2 白Friioだと1)(4/"+str(maxn)+")")
    te_max=raw_input("te_max : ")
    te_max=str(int(te_max))
    configwriter.setenv("te_max", te_max)
    recdblist.printutf8(u"BS/CS110録画可能数(PT*だと2 黒Friioだと1)(5/"+str(maxn)+")")
    bscs_max=raw_input("bscs_max : ")
    bscs_max=str(int(bscs_max))
    configwriter.setenv("bscs_max", bscs_max)
    recdblist.printutf8(u"同時エンコード最大数を設定してください(6/"+str(maxn)+")")
    recdblist.printutf8(u"CPUのコア数が目安です")
    enc_max=raw_input("[2]:")
    if enc_max=="":
        enc_max="2"
    else:
        enc_max=str(int(enc_max))
    configwriter.setenv("enc_max", enc_max)

    recdblist.printutf8(u"二カ国語放送/5.1ch放送の音声変換の設定です。\nNeroAACエンコーダーを使用しますか?(NeroAACEncを別途入手してtstoolsに入れてください。))")
    recdblist.printutf8(u"入手先:http://www.nero.com/jpn/technologies-aac-codec.html\n (7/"+str(maxn)+")")
    audioenc=raw_input("[y/N]:  ")
    if audioenc=="y" or audioenc=="Y":
        configwriter.setpath("useNeroAAC", "1")
        recdblist.printutf8(u"NeroAACEncのパスを指定してください")
        aacpath=raw_input("[/usr/local/bin/neroAacEnc] : ")
        if aacpath.replace(" ","")!="" and os.path.isfile(aacpath):
            configwriter.setpath("NeroAAC", aacpath)
        else:
            recdblist.printutf8(u"実行可能ファイルが見つかりませんでした。")
            configwriter.setpath("useNeroAAC", "0")
            recdblist.printutf8(u"lameを使用します。")
    else:
        recdblist.printutf8(u"lameを使用します。")
    recdblist.printutf8(u"チャンネルの設定に入ります(8/"+str(maxn)+")")
    recdblist.printutf8(u"rec10を設置する地域を選んでください。")
    recdblist.printutf8(u"1:東京 2:神戸 3:名古屋 4:その他")
    ch=raw_input()
    ch=int(ch)
    if ch==1:
        shutil.copy(os.path.join(path,"chlist_sample_tokyo.xml"),os.path.join(path,"chlist.xml"))
    elif ch==2:
        shutil.copy(os.path.join(path,"chlist_sample_kobe.xml"),os.path.join(path,"chlist.xml"))
    elif ch==3:
        shutil.copy(os.path.join(path,"chlist_sample_nagoya.xml"),os.path.join(path,"chlist.xml"))
    elif ch==4:
        recdblist.printutf8(u"チャンネルの設定が必要です。")
        recdblist.printutf8(u"chlist_sample_*を参考にchlist.xmlを作成した後に次のステップに進んでください。")
        time.sleep(5)
    recdblist.printutf8(u"BS放送は受信可能ですか？(9/"+str(maxn)+")")
    bsok=raw_input("y/N:")
    if bsok=="Y" or bsok == "y" :
        bsok="1"
    else:
        bsok="0"
    configwriter.setenv("bs", bsok)
    recdblist.printutf8(u"CS放送(スカパーe2)は受信可能ですか？(10/"+str(maxn)+")")
    csok=raw_input("y/N:")
    if csok=="Y" or csok == "y" :
        csok="1"
        recdblist.printutf8(u"標準パックの番組は入力してありますがそれ以外は追加でchlist_cs.xmlに追加する必要があります。")
    else:
        csok="0"
    configwriter.setenv("cs", csok)
    configwriter.writeconf()
    recdblist.printutf8(u"初期設定が終了しました。")
    recdblist.printutf8(u"makeを実行した後にrootにてmake installを実行するとインストールされます。")
if __name__ == "__main__":
    move()